/*
 * Decompiled with CFR 0.152.
 */
package com.neoteris;

import com.neoteris.Logger;
import com.neoteris.NeoterisInetAddress;
import com.neoteris.NeoterisSocket;
import com.neoteris.NeoterisURL;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class NeoterisStatic14 {
    public static InetSocketAddress translateInetSocketAddress(NeoterisInetAddress neoterisInetAddress, int n) {
        try {
            InetSocketAddress inetSocketAddress = null;
            if (null == neoterisInetAddress) {
                if (Logger.isLogging()) {
                    Logger.log("src/NeoterisStatic14.java", 24, 2, "null inet address");
                }
                inetSocketAddress = new InetSocketAddress(n);
            } else {
                InetAddress inetAddress = InetAddress.getByAddress(neoterisInetAddress.getHostName(), neoterisInetAddress.getAddress());
                inetSocketAddress = new InetSocketAddress(inetAddress, n);
            }
            return inetSocketAddress;
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("translateInetSocketAddress couldn't get remote address for " + neoterisInetAddress.getHostName());
        }
    }

    public static InetSocketAddress translateInetSocketAddress(int n) {
        return new InetSocketAddress(n);
    }

    public static InetSocketAddress translateInetSocketAddress(String string, int n) {
        return NeoterisStatic14.translateInetSocketAddress(new NeoterisInetAddress(string), n);
    }

    public static void doSocketConnect(Socket socket, SocketAddress socketAddress) throws IOException {
        NeoterisStatic14.doSocketConnect(socket, socketAddress, 0);
    }

    public static void doSocketConnect(Socket socket, SocketAddress socketAddress, int n) throws IOException {
        NeoterisSocket neoterisSocket;
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (!(socket instanceof NeoterisSocket)) {
            if (Logger.isLogging()) {
                Logger.log("src/NeoterisStatic14.java", 63, 2, "Socket passed to doSocketConnect is not a NeoterisSocket, looking for a NeoterisSocket which has this socket as its parent");
            }
            neoterisSocket = NeoterisSocket.getSocketWithParent(socket);
            if (neoterisSocket == null) {
                if (Logger.isLogging()) {
                    Logger.log("src/NeoterisStatic14.java", 66, 2, "Failed to find a NeoterisSocket which has socket " + socket + " as its parent");
                }
                socket.connect(socketAddress, n);
                return;
            }
        } else {
            neoterisSocket = (NeoterisSocket)socket;
        }
        NeoterisInetAddress neoterisInetAddress = new NeoterisInetAddress(inetSocketAddress.getAddress());
        int n2 = inetSocketAddress.getPort();
        neoterisSocket.connectWithHostPort(neoterisInetAddress, n2, n);
    }

    public static SocketAddress getRemoteSocketAddress(Socket socket) {
        if (NeoterisStatic14.isSocketConnected(socket)) {
            try {
                NeoterisInetAddress neoterisInetAddress = NeoterisSocket.getInetAddress(socket);
                InetAddress inetAddress = InetAddress.getByAddress(neoterisInetAddress.getHostName(), neoterisInetAddress.getAddress());
                return new InetSocketAddress(inetAddress, socket.getPort());
            }
            catch (Exception exception) {
                if (!Logger.isLogging()) {
                    // empty if block
                }
                Logger.log("src/NeoterisStatic14.java", 91, 4, "Exception while creating SocketAddress: " + exception);
            }
        }
        return null;
    }

    public static boolean isSocketConnected(Socket socket) {
        if (socket instanceof NeoterisSocket) {
            return ((NeoterisSocket)socket).isSocketConnected();
        }
        return socket.isConnected();
    }

    public static InputSource translateInputSource() {
        return new InputSource();
    }

    public static InputSource translateInputSource(InputStream inputStream) {
        return new InputSource(inputStream);
    }

    public static InputSource translateInputSource(Reader reader) {
        return new InputSource(reader);
    }

    public static InputSource translateInputSource(String string) {
        InputSource inputSource = new InputSource();
        NeoterisStatic14.setSystemId(inputSource, string);
        return inputSource;
    }

    public static void setSystemId(InputSource inputSource, String string) {
        block2: {
            try {
                NeoterisURL neoterisURL = new NeoterisURL(string);
                inputSource.setSystemId(neoterisURL.b().toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                if (!Logger.isLogging()) break block2;
                Logger.log("src/NeoterisStatic14.java", 135, 2, "Exception while translating InputSource: " + malformedURLException);
            }
        }
    }

    public static void parse(Parser parser, String string) throws SAXException, IOException {
        InputSource inputSource = NeoterisStatic14.translateInputSource(string);
        parser.parse(inputSource);
    }

    public static void parse(Parser parser, InputSource inputSource) throws SAXException, IOException {
        parser.parse(inputSource);
    }

    public static void parse(XMLReader xMLReader, String string) throws SAXException, IOException {
        InputSource inputSource = NeoterisStatic14.translateInputSource(string);
        xMLReader.parse(inputSource);
    }

    public static void parse(XMLReader xMLReader, InputSource inputSource) throws SAXException, IOException {
        xMLReader.parse(inputSource);
    }

    public static NetworkInterface translateGetByInetAddress(NeoterisInetAddress neoterisInetAddress) throws SocketException, NullPointerException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByAddress(neoterisInetAddress.getAddress());
        }
        catch (Exception exception) {
            if (!Logger.isLogging()) {
                // empty if block
            }
            Logger.log("src/NeoterisStatic14.java", 173, 4, "Exception while getting address from NeoterisInetAddress: " + exception);
            return null;
        }
        return NetworkInterface.getByInetAddress(inetAddress);
    }

    public static int getDefaultPort(URL uRL) {
        try {
            NeoterisURL neoterisURL = new NeoterisURL(uRL);
            return neoterisURL.c().getDefaultPort();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static void doBind(Socket socket, SocketAddress socketAddress) throws IOException {
        block2: {
            try {
                socket.bind(socketAddress);
            }
            catch (Exception exception) {
                if (!Logger.isLogging()) break block2;
                Logger.log("src/NeoterisStatic14.java", 195, 2, "Cannot bind a socket to a local address:" + exception);
            }
        }
    }
}

