/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.HttpNAR;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;

public class DiameterAVP {
    public static final int AVP_HEADER_LENGTH = 8;
    public static final int AVP_VS_HEADER_LENGTH = 12;
    public static final int AVP_FLAG_P = 0x20000000;
    public static final int AVP_FLAG_M = 0x40000000;
    public static final int AVP_FLAG_V = Integer.MIN_VALUE;
    public static final int RAD_ATTR_FUNK_TNC_MESSAGE_BATCH = 3300;
    public static final int RAD_ATTR_FUNK_TNC_TNCC_LANGUAGE = 3301;
    public static final int RAD_ATTR_FUNK_TNC_TNCS_REASON = 3302;
    public static final int RAD_ATTR_FUNK_TNC_INTEGRITY_MESSAGE = 3303;
    public static final int RAD_ATTR_FUNK_TNC_BEGIN_HANDSHAKE = 3306;
    public static final int RAD_ATTR_FUNK_UAC_POLICY_REMEDIATION = 3312;
    public static final int RAD_ATTR_FUNK_UAC_POLICY_NAME = 3313;
    public static final int RAD_ATTR_FUNK_UAC_POLICY_CUSTOM_INSTRUCTIONS = 3314;
    public static final int RAD_ATTR_FUNK_INTEGRITY_RESULT = 18;
    public static final int RAD_ATTR_FUNK_TNC_PAYLOAD = 19;
    public static final int VID_FUNK_SOFTWARE = 1411;
    protected int mAVPCode = 0;
    protected int mAVPFlags = 0;
    protected int mAVPVendorID = 0;
    protected ByteArrayOutputStream mAVPValue = new ByteArrayOutputStream();

    public DiameterAVP(byte[] byArray) throws IOException, StreamCorruptedException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.mAVPCode = byteBuffer.getInt();
        int n = byteBuffer.getInt();
        this.mAVPFlags = n & 0xF0000000;
        n &= 0xFFFFFF;
        if (0 != (this.mAVPFlags & Integer.MIN_VALUE)) {
            this.mAVPVendorID = byteBuffer.getInt();
            n -= 12;
        } else {
            this.mAVPVendorID = 0;
            n -= 8;
        }
        if (byteBuffer.remaining() < this.padLength(n)) {
            throw new StreamCorruptedException("Invalid AVP value length. Required: " + this.padLength(n) + ", actual: " + byteBuffer.remaining());
        }
        this.mAVPValue.write(byteBuffer.array(), byteBuffer.position(), n);
    }

    public DiameterAVP(int n, int n2, int n3, byte[] byArray) throws IOException {
        this.mAVPCode = n;
        this.mAVPFlags = n2;
        this.mAVPVendorID = n3;
        this.appendToValue(byArray);
    }

    public void appendToValue(byte[] byArray) throws IOException {
        this.mAVPValue.write(byArray);
    }

    public byte[] toByteArray() {
        return this.toByteBuffer().array();
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getAVPLength());
        byteBuffer.putInt(this.mAVPCode);
        byteBuffer.putInt(this.mAVPFlags | this.getHeaderLength() + this.getAVLValueLength());
        if (0 != (this.mAVPFlags & Integer.MIN_VALUE)) {
            byteBuffer.putInt(this.mAVPVendorID);
        }
        byteBuffer.put(this.mAVPValue.toByteArray());
        return byteBuffer;
    }

    public int getAVPCode() {
        return this.mAVPCode;
    }

    public int getAVPFlags() {
        return this.mAVPFlags;
    }

    public int getAVPVEndorID() {
        return this.mAVPVendorID;
    }

    public int getHeaderLength() {
        return 0 == (this.mAVPFlags & Integer.MIN_VALUE) ? 8 : 12;
    }

    public int getAVPLength() {
        return this.getHeaderLength() + this.padLength(this.getAVLValueLength());
    }

    public int getAVLValueLength() {
        return this.mAVPValue.size();
    }

    public byte[] getAVPValue() {
        return this.mAVPValue.toByteArray();
    }

    protected int padLength(int n) {
        return 3 + n & 0xFFFFFFFC;
    }
}

