/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.HttpNAR;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Vector;
import net.juniper.tnc.HttpNAR.DiameterAVP;
import net.juniper.tnc.HttpNAR.DiameterAVPSequence;
import net.juniper.tnc.HttpNAR.HttpConnection;
import net.juniper.tnc.HttpNAR.HttpNAR;
import net.juniper.tnc.HttpNAR.LoginTimeoutThread;
import net.juniper.tnc.HttpNAR.NARUtil;
import net.juniper.tnc.HttpNAR.TncConnection;
import net.juniper.tnc.HttpNAR.TncHandshakeResult;
import org.trustedcomputinggroup.tnc.TNCException;
import org.trustedcomputinggroup.tnc.ifimc.IMC;

public class TncHandshake
implements Runnable {
    private static final String cls = "TncHandshake: ";
    private HttpNAR mHttpNAR = null;
    private IMC mTncClient = null;
    private String mIcURL = null;
    private String mCookie = "";
    private String mSignIn = "";
    private String mUserAgent;
    private TncConnection mTncConnection = null;
    private long mCheckInterval = 0L;
    private boolean mLoggedIn = false;
    private LoginTimeoutThread mLoginTimeoutThread;
    private boolean mShowRemediationData = true;
    private boolean mFirstHandshake = true;
    private Vector mPolicies = new Vector();
    private Vector mCustomInstructions = new Vector();
    private Vector mReasonStrings = new Vector();
    private long mHandshakeResult = 2L;

    public TncHandshake(HttpNAR httpNAR, IMC iMC, String string, long l) {
        this.mTncClient = iMC;
        this.mUserAgent = string;
        this.mHttpNAR = httpNAR;
        this.mLoginTimeoutThread = new LoginTimeoutThread(this, l);
    }

    @Override
    public void run() {
    }

    public boolean isLoggedIn() {
        return this.mLoggedIn;
    }

    public void setLoggedIn(boolean bl) {
        this.mLoggedIn = bl;
    }

    public String getIcURL() {
        return this.mIcURL;
    }

    public String getCookie() {
        return this.mCookie;
    }

    public void setShowRemediationData(boolean bl) {
        this.mShowRemediationData = bl;
    }

    public void stop() {
        this.mHttpNAR.stop();
    }

    public void updateCookie(BufferedReader bufferedReader) {
        try {
            this.readCookieParameters(bufferedReader);
            NARUtil.logInfo("TncHandshake: New cookie value: DSPREAUTH=" + this.mCookie);
            this.mLoggedIn = true;
            if (0L < this.mCheckInterval) {
                this.mHttpNAR.scheduleHandshakeRetry(this.mCheckInterval, this.mTncConnection);
            }
        }
        catch (Exception exception) {
            NARUtil.logException(exception);
        }
    }

    public void retryHandshake() {
        int n = 500;
        TncHandshakeResult tncHandshakeResult = new TncHandshakeResult();
        try {
            NARUtil.logInfo("TncHandshake: Retrying handshake...");
            n = this.doTncExchange(tncHandshakeResult);
            if (0L < this.mCheckInterval) {
                this.mHttpNAR.scheduleHandshakeRetry(this.mCheckInterval, this.mTncConnection);
            }
        }
        catch (Exception exception) {
            NARUtil.logException(exception);
            n = 500;
        }
        NARUtil.logInfo("TncHandshake: Handshake retried with response " + n + " and result " + tncHandshakeResult.mHandshakeResult);
        if (this.mShowRemediationData && 200 == n && this.mLoggedIn && tncHandshakeResult.mInstructions.length() > 0) {
            NARUtil.logInfo("TncHandshake: Displaying custom remediation instructions");
            this.doCustomRemediateInstructions();
        }
        if (200 != n || this.mLoggedIn && 4L == tncHandshakeResult.mHandshakeResult) {
            this.stop();
        }
    }

    public void tryAgain(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        int n = 500;
        TncHandshakeResult tncHandshakeResult = new TncHandshakeResult();
        try {
            NARUtil.logInfo("TncHandshake: Try again...");
            n = this.doTncExchange(tncHandshakeResult);
        }
        catch (Exception exception) {
            NARUtil.logException(exception);
            n = 500;
        }
        try {
            printWriter.println(n);
            printWriter.println(tncHandshakeResult.mHandshakeResult);
            printWriter.println(tncHandshakeResult.mCookie);
            printWriter.println(tncHandshakeResult.mPolicyCount);
            printWriter.println(tncHandshakeResult.mInstructions.toString());
            if (this.mTncConnection != null && this.mTncConnection.getmIMCParams() != null) {
                printWriter.println(this.mTncConnection.getmIMCParams().serialize());
            }
            printWriter.close();
            printWriter.close();
        }
        catch (Exception exception) {
            NARUtil.logException(exception);
        }
    }

    public void runHandshake(BufferedReader bufferedReader, OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        int n = 500;
        TncHandshakeResult tncHandshakeResult = new TncHandshakeResult();
        try {
            NARUtil.logInfo("TncHandshake: Reading command parameters");
            this.readHandshakeParameters(bufferedReader);
            if (this.mLoginTimeoutThread.getLoginTimeout() > 0L) {
                this.mLoginTimeoutThread.start();
            }
            n = this.doTncExchange(tncHandshakeResult);
        }
        catch (Exception exception) {
            NARUtil.logException(exception);
            n = 500;
        }
        try {
            printWriter.println(n);
            printWriter.println(tncHandshakeResult.mHandshakeResult);
            printWriter.println(tncHandshakeResult.mCookie);
            if (this.mTncConnection != null && this.mTncConnection.getmIMCParams() != null) {
                printWriter.println(this.mTncConnection.getmIMCParams().serialize());
            }
            printWriter.println(tncHandshakeResult.mPolicyCount);
            printWriter.println(tncHandshakeResult.mInstructions.toString());
            printWriter.close();
            printWriter.close();
        }
        catch (Exception exception) {
            NARUtil.logException(exception);
        }
    }

    public void terminate() {
        try {
            if (null != this.mTncConnection) {
                this.mTncClient.notifyConnectionChange(this.mTncConnection, 5L);
                this.mTncConnection.close();
                this.mTncConnection = null;
            }
            if (this.mLoginTimeoutThread.isRunning()) {
                this.mLoginTimeoutThread.interrupt();
            }
            this.mHttpNAR = null;
            this.mTncClient = null;
        }
        catch (Exception exception) {
            NARUtil.logException(exception);
        }
    }

    private synchronized int doTncExchange(TncHandshakeResult tncHandshakeResult) throws Exception {
        int n = 500;
        if (null != this.mTncConnection) {
            this.mTncClient.notifyConnectionChange(this.mTncConnection, 5L);
            this.mTncConnection.close();
        }
        this.mTncConnection = new TncConnection(this);
        this.mTncClient.notifyConnectionChange(this.mTncConnection, 0L);
        HttpConnection httpConnection = new HttpConnection(this.mIcURL, this.mCookie, this.mUserAgent, this.mSignIn);
        this.mTncClient.notifyConnectionChange(this.mTncConnection, 1L);
        this.mTncClient.beginHandshake(this.mTncConnection);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.mHandshakeResult = 2L;
        this.mPolicies.clear();
        this.mCustomInstructions.clear();
        this.mReasonStrings.clear();
        do {
            byte[] byArray = this.mTncConnection.getAccumulatedMessages();
            byteArrayOutputStream.reset();
            n = httpConnection.sendUpdate(byArray, byteArrayOutputStream, this.mFirstHandshake);
            if (200 != n || 0 == byteArrayOutputStream.size()) break;
            this.mTncConnection.clear();
            this.parseTncsPayload(byteArrayOutputStream.toByteArray());
        } while (httpConnection.isHandshakeInProgress());
        this.mFirstHandshake = false;
        this.mCookie = httpConnection.getCookie();
        this.mCheckInterval = httpConnection.getCheckInterval();
        tncHandshakeResult.mPolicyCount = this.getUserRemediationInstructions(tncHandshakeResult.mInstructions);
        tncHandshakeResult.mHandshakeResult = this.mHandshakeResult;
        tncHandshakeResult.mCookie = this.mCookie;
        return n;
    }

    private void readHandshakeParameters(BufferedReader bufferedReader) throws Exception {
        String string = bufferedReader.readLine();
        if (string != null && string.startsWith("IC=")) {
            this.mIcURL = string.substring(3);
            this.readCookieParameters(bufferedReader);
            string = bufferedReader.readLine();
            if (string != null && string.startsWith("DSSIGNIN=")) {
                this.mSignIn = string.substring(9);
                NARUtil.logInfo("TncHandshake: Handshake parameters: IC=" + this.mIcURL + "; DSSIGNIN=" + this.mSignIn + "; Cookie=" + this.mCookie);
                return;
            }
        }
        throw new Exception("Invalid command input.");
    }

    private void readCookieParameters(BufferedReader bufferedReader) throws Exception {
        String string = bufferedReader.readLine();
        if (string != null && string.startsWith("Cookie=")) {
            this.mCookie = string.substring(7);
            return;
        }
        throw new Exception("Invalid command input.");
    }

    public void doCustomRemediateInstructions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("https://").append(this.mIcURL);
        stringBuffer.append("/dana-na/auth/rdpreauth.cgi?DSPREAUTH=" + this.mCookie);
        String string = stringBuffer.toString();
        NARUtil.logInfo("TncHandshake: launching browser for " + string);
        String string2 = NARUtil.isMacOSX() ? "open -a Safari " : (NARUtil.isLinux() || NARUtil.isSolaris() ? "firefox " : "");
        NARUtil.execCommand(string2 + string);
        NARUtil.logInfo("TncHandshake: browser launched");
    }

    private void parseTncsPayload(byte[] byArray) throws TNCException {
        try {
            DiameterAVPSequence diameterAVPSequence = new DiameterAVPSequence(byArray);
            Iterator iterator = diameterAVPSequence.iterator();
            while (iterator.hasNext()) {
                this.ParseTncPayloadMessage((DiameterAVP)iterator.next());
            }
            try {
                this.mTncClient.batchEnding(this.mTncConnection);
            }
            catch (TNCException tNCException) {
                NARUtil.logError("TncHandshake: TNCC batchEnding returned with error \"" + tNCException.getMessage() + "\"");
                NARUtil.logException(tNCException);
            }
        }
        catch (Exception exception) {
            throw new TNCException(exception.getMessage(), 9L);
        }
    }

    private void ParseTncPayloadMessage(DiameterAVP diameterAVP) throws Exception {
        DiameterAVP diameterAVP2;
        long[] lArray = new long[]{2L, 4L, 3L, 4L};
        if (19 != diameterAVP.getAVPCode()) {
            throw new TNCException("Bad message format", 9L);
        }
        DiameterAVPSequence diameterAVPSequence = new DiameterAVPSequence(diameterAVP.getAVPValue());
        Iterator iterator = diameterAVPSequence.iterator();
        while (iterator.hasNext()) {
            diameterAVP2 = (DiameterAVP)iterator.next();
            switch (diameterAVP2.getAVPCode()) {
                case 3300: {
                    this.ParseMessageBatch(diameterAVP2.getAVPValue());
                    break;
                }
                case 3312: {
                    this.ParsePolicyRemediationData(diameterAVP2.getAVPValue());
                }
            }
        }
        iterator = diameterAVPSequence.iterator();
        while (iterator.hasNext()) {
            diameterAVP2 = (DiameterAVP)iterator.next();
            if (18 != diameterAVP2.getAVPCode()) continue;
            int n = ByteBuffer.wrap(diameterAVP2.getAVPValue()).getInt();
            this.mTncClient.notifyConnectionChange(this.mTncConnection, lArray[n]);
            NARUtil.logInfo("TncHandshake: recevied integrity result: " + lArray[n]);
            this.mHandshakeResult = lArray[n];
            break;
        }
    }

    private void ParseMessageBatch(byte[] byArray) throws Exception {
        DiameterAVPSequence diameterAVPSequence = new DiameterAVPSequence(byArray);
        Iterator iterator = diameterAVPSequence.iterator();
        while (iterator.hasNext()) {
            DiameterAVP diameterAVP = (DiameterAVP)iterator.next();
            if (3303 == diameterAVP.getAVPCode()) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(diameterAVP.getAVPValue());
                int n = byteBuffer.getInt();
                byte[] byArray2 = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray2);
                try {
                    this.mTncClient.receiveMessage(this.mTncConnection, n, byArray2);
                }
                catch (TNCException tNCException) {
                    NARUtil.logError("TncHandshake: receiveMessage of TNCC returned with error \"" + tNCException.getMessage() + "\"");
                    NARUtil.logException(tNCException);
                }
                continue;
            }
            NARUtil.logError("TncHandshake: invalid AVP type " + diameterAVP.getAVPCode());
        }
    }

    private void ParsePolicyRemediationData(byte[] byArray) throws Exception {
        DiameterAVPSequence diameterAVPSequence = new DiameterAVPSequence(byArray);
        String string = "";
        String string2 = "";
        String string3 = "";
        Iterator iterator = diameterAVPSequence.iterator();
        while (iterator.hasNext()) {
            DiameterAVP diameterAVP = (DiameterAVP)iterator.next();
            switch (diameterAVP.getAVPCode()) {
                case 3313: {
                    string3 = new String(diameterAVP.getAVPValue());
                    break;
                }
                case 3314: {
                    string = new String(diameterAVP.getAVPValue());
                    break;
                }
                case 3302: {
                    string2 = string2 + new String(diameterAVP.getAVPValue()) + "\n";
                    break;
                }
                case 3300: {
                    this.ParseMessageBatch(diameterAVP.getAVPValue());
                }
            }
        }
        if (string3.length() > 0 && (string.length() > 0 || string2.length() > 0)) {
            NARUtil.logInfo("TncHandshake: received remediation instructions for policy `" + string3 + "'");
            NARUtil.logInfo("TncHandshake: message: `" + string + "'");
            NARUtil.logInfo("TncHandshake: reason: `" + string2 + "'");
            this.mPolicies.add(string3);
            this.mCustomInstructions.add(string);
            this.mReasonStrings.add(string2);
        }
    }

    private int getUserRemediationInstructions(StringBuffer stringBuffer) {
        Iterator iterator = this.mPolicies.iterator();
        Iterator iterator2 = this.mCustomInstructions.iterator();
        Iterator iterator3 = this.mReasonStrings.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)iterator2.next();
            String string3 = (String)iterator3.next();
            if (string2.length() <= 0 && string3.length() <= 0) continue;
            stringBuffer.append(string + "\u0000");
            stringBuffer.append(string2 + "\u0000");
            stringBuffer.append(string3 + "\u0000\n");
            ++n;
        }
        return n;
    }
}

