/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.juniper.tnc.client.HandshakeEngine;
import net.juniper.tnc.client.IMCCollection;
import net.juniper.tnc.client.TNCCUtil;
import net.juniper.tnc.interfaces.JuniperTNCC;
import org.trustedcomputinggroup.tnc.TNCException;
import org.trustedcomputinggroup.tnc.ifimc.IMC;
import org.trustedcomputinggroup.tnc.ifimc.IMCConnection;
import org.trustedcomputinggroup.tnc.ifimc.TNCC;

public class TNCClient
implements IMC {
    private static final String cls = "TNCClintNAR: ";
    private Map mHandshakeMap = Collections.synchronizedMap(new HashMap());
    private IMCCollection mIMCs = new IMCCollection(this);
    private TNCC mNAR = null;
    private static final int TNC_CONFIG_MODULE_TYPE = 0;
    private static final int TNC_CONFIG_MODULE_NAME = 1;
    private static final int TNC_CONFIG_MODULE_CLASS = 2;
    private static final int TNC_CONFIG_MODULE_URL = 3;

    public void requestHandshakeRetry(long l) throws TNCException {
        if (null == this.mNAR) {
            throw new TNCException("Client not initialized.", 1L);
        }
        this.mNAR.requestHandshakeRetry(this, l);
    }

    @Override
    public void initialize(TNCC tNCC) throws TNCException {
        try {
            JuniperTNCC juniperTNCC = null;
            try {
                juniperTNCC = (JuniperTNCC)tNCC;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            TNCCUtil.startLogging(juniperTNCC);
            TNCCUtil.logInfo("TNCClintNAR: initializing");
            this.mNAR = tNCC;
            this.load_tnc_config();
        }
        catch (Exception exception) {
            throw new TNCException(exception.toString(), 9L);
        }
    }

    public void loadbundledIMC(String string, String string2, String string3, int n) {
        this.mIMCs.installIMC(string, string2, string3, n);
    }

    @Override
    public void terminate() throws TNCException {
        try {
            TNCCUtil.logInfo("TNCClintNAR: terminating");
            this.mNAR = null;
            this.mHandshakeMap.clear();
            TNCCUtil.stopLogging();
            this.mIMCs.terminate();
        }
        catch (Exception exception) {
            throw new TNCException(exception.getMessage(), 9L);
        }
    }

    @Override
    public void beginHandshake(IMCConnection iMCConnection) throws TNCException {
        HandshakeEngine handshakeEngine = (HandshakeEngine)this.mHandshakeMap.get(iMCConnection);
        if (null == handshakeEngine) {
            throw new TNCException("Unknown connection.", 6L);
        }
        handshakeEngine.beginHandshake(iMCConnection);
    }

    @Override
    public void receiveMessage(IMCConnection iMCConnection, long l, byte[] byArray) throws TNCException {
        HandshakeEngine handshakeEngine = (HandshakeEngine)this.mHandshakeMap.get(iMCConnection);
        if (null == handshakeEngine) {
            throw new TNCException("Unknown connection.", 6L);
        }
        handshakeEngine.receiveMessage(iMCConnection, l, byArray);
    }

    @Override
    public void batchEnding(IMCConnection iMCConnection) throws TNCException {
        HandshakeEngine handshakeEngine = (HandshakeEngine)this.mHandshakeMap.get(iMCConnection);
        if (null == handshakeEngine) {
            throw new TNCException("Unknown connection.", 6L);
        }
        handshakeEngine.batchEnding(iMCConnection);
    }

    @Override
    public void notifyConnectionChange(IMCConnection iMCConnection, long l) throws TNCException {
        HandshakeEngine handshakeEngine;
        if (0L == l) {
            try {
                if (this.mHandshakeMap.containsKey(iMCConnection)) {
                    handshakeEngine = (HandshakeEngine)this.mHandshakeMap.get(iMCConnection);
                }
                handshakeEngine = new HandshakeEngine(iMCConnection, this.mIMCs);
                this.mHandshakeMap.put(iMCConnection, handshakeEngine);
            }
            catch (Exception exception) {
                throw new TNCException(exception.getMessage(), 9L);
            }
        } else {
            handshakeEngine = (HandshakeEngine)this.mHandshakeMap.get(iMCConnection);
        }
        if (null == handshakeEngine) {
            throw new TNCException("Unknown connection.", 6L);
        }
        handshakeEngine.notifyConnectionChange(iMCConnection, l);
        if (5L == l) {
            this.mHandshakeMap.remove(iMCConnection);
        }
    }

    private void load_tnc_config() {
        String string = System.getProperty("os.name").regionMatches(true, 0, "windows", 0, 7) ? "c:\\windows\\" : "/etc/";
        string = string + "tnc_config";
        this.process_tnc_config(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process_tnc_config(String string) {
        BufferedReader bufferedReader = null;
        try {
            File file = new File(string);
            if (!file.canRead()) {
                TNCCUtil.logInfo("TNCClintNAR: Unable to read " + string);
                return;
            }
            bufferedReader = new BufferedReader(new FileReader(file));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(1, 9);
            streamTokenizer.wordChars(11, 65535);
            streamTokenizer.quoteChar(34);
            streamTokenizer.whitespaceChars(32, 32);
            streamTokenizer.whitespaceChars(13, 13);
            streamTokenizer.commentChar(35);
            streamTokenizer.eolIsSignificant(true);
            while (this.parseLine(streamTokenizer) != -1) {
            }
        }
        catch (Exception exception) {
            TNCCUtil.logException(exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    bufferedReader = null;
                }
                catch (IOException iOException) {
                    bufferedReader = null;
                }
            }
        }
    }

    private int parseLine(StreamTokenizer streamTokenizer) throws IOException {
        int n;
        int[] nArray = new int[]{-3, 34, -3, -3, 10};
        String[] stringArray = new String[nArray.length];
        for (n = 0; n < nArray.length && nArray[n] == streamTokenizer.nextToken(); ++n) {
            stringArray[n] = streamTokenizer.sval;
            if (2 != n) continue;
            streamTokenizer.wordChars(32, 32);
        }
        if (n == nArray.length && 0 == stringArray[0].compareToIgnoreCase("java-imc")) {
            this.mIMCs.installIMC(stringArray[1], stringArray[3], stringArray[2], 1);
        }
        streamTokenizer.whitespaceChars(32, 32);
        return n < nArray.length && 10 != streamTokenizer.ttype ? this.skipLine(streamTokenizer) : streamTokenizer.ttype;
    }

    private int skipLine(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        while (n != -1 && n != 10) {
            n = streamTokenizer.nextToken();
        }
        return n;
    }
}

