/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.hostcheckerimc;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import net.juniper.tnc.hostcheckerimc.HCRule;
import net.juniper.tnc.hostcheckerimc.HCUtil;

public class HCFileRule
extends HCRule {
    static final String cls = "HCFileRule: ";
    static final int MILLISEC_PER_DAY = 86400000;
    static final int FILE_FOUND = 0;
    static final int FILE_FOUND_TOO_OLD = 1;
    static final int FILE_FOUND_BAD_CHECKSUM = 2;
    static final int FILE_FOUND_BAD_VERSION = 3;
    static final int FILE_FOUND_NO_VERSION = 4;
    static final int FILE_NOT_FOUND = 5;
    String mRulename;
    int mRuleid;
    String mPath;
    String mChecksumsString;
    String mChecksumsSha256String;
    String[] mChecksums;
    String[] mChecksumsSha256;
    boolean mFlag;
    int mAge;
    long mLastTooOldFileAge;

    public HCFileRule(Properties properties, int n) {
        super(properties, n);
        if (properties == null) {
            return;
        }
        this.mPath = properties.getProperty("file" + n);
        if (!HCUtil.isEmpty(this.mPath)) {
            int n2;
            int n3;
            StringTokenizer stringTokenizer;
            this.mChecksumsString = properties.getProperty("cksum" + n);
            if (this.mChecksumsString != null && !HCUtil.isEmpty(this.mChecksumsString = this.mChecksumsString.trim())) {
                stringTokenizer = new StringTokenizer(this.mChecksumsString, ",");
                n3 = stringTokenizer.countTokens();
                this.mChecksums = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.mChecksums[n2] = (String)stringTokenizer.nextElement();
                }
            }
            this.mChecksumsSha256String = properties.getProperty("sha256cksum");
            if (this.mChecksumsSha256String != null && !HCUtil.isEmpty(this.mChecksumsSha256String = this.mChecksumsSha256String.trim())) {
                stringTokenizer = new StringTokenizer(this.mChecksumsSha256String, ",");
                n3 = stringTokenizer.countTokens();
                this.mChecksumsSha256 = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.mChecksumsSha256[n2] = (String)stringTokenizer.nextElement();
                }
            }
            this.mFlag = HCUtil.getBoolInt(properties.getProperty("flag" + n), "flag" + n, true);
            this.mAge = HCUtil.getInt(properties.getProperty("age" + n), "age" + n, -1);
        } else {
            HCUtil.logError("No or empty file" + n + " in policy " + this.mPolicyId);
        }
    }

    private static Vector expandFilePaths(String string) {
        Vector<String> vector = new Vector<String>();
        if ((string = HCUtil.substituteEnvVars(string)) == null) {
            return vector;
        }
        if (HCUtil.containsWildcards(string)) {
            String string2 = HCUtil.convertWildcardsToRegex(string);
            HCUtil.logInfo("HCFileRule: filepath converted to regex ");
            Pattern pattern = Pattern.compile(string2);
            int n = string.lastIndexOf(File.separator);
            if (n != -1) {
                File file = new File(string.substring(0, n));
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    for (int k = 0; k < fileArray.length; ++k) {
                        String string3 = fileArray[k].getPath();
                        if (!pattern.matcher(string3).matches()) continue;
                        vector.add(string3);
                    }
                } else {
                    HCUtil.logError("HCFileRule: invalid filepath ; no matching files");
                }
            } else {
                HCUtil.logError("couldn't find the file separator");
            }
        } else {
            vector.add(string);
        }
        return vector;
    }

    private boolean isFileTooOld(File file, String string, int n) {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        try {
            l2 = (l - file.lastModified()) / 86400000L;
            if (l2 >= (long)n) {
                this.mLastTooOldFileAge = l2;
                return true;
            }
        }
        catch (SecurityException securityException) {
            HCUtil.logException(securityException);
            this.mLastTooOldFileAge = -1L;
            return true;
        }
        return false;
    }

    private boolean checkChecksum(File file, String string) {
        int n;
        String string2;
        boolean bl = true;
        boolean bl2 = true;
        if (this.mChecksums != null) {
            bl = false;
            string2 = HCUtil.computeFileMD5(file);
            if (string2 != null) {
                for (n = 0; n < this.mChecksums.length && !bl; ++n) {
                    bl = string2.equalsIgnoreCase(this.mChecksums[n]);
                }
                HCUtil.logInfo("HCFileRule: MD5: file actual checksum " + (bl ? "matches " : "does not match ") + "an expected checksum");
            } else {
                HCUtil.logError("couldn't compute file MD5 checksum");
            }
        }
        if (this.mChecksumsSha256 != null) {
            bl2 = false;
            string2 = HCUtil.computeFileSHA256(file);
            if (string2 != null) {
                for (n = 0; n < this.mChecksumsSha256.length && !bl2; ++n) {
                    bl2 = string2.equalsIgnoreCase(this.mChecksumsSha256[n]);
                }
                HCUtil.logInfo("HCFileRule: SHA256: file actual checksum " + (bl2 ? "matches " : "does not match ") + "an expected checksum");
            } else {
                HCUtil.logError("couldn't compute file SHA256 checksum");
            }
        }
        return bl && bl2;
    }

    private int findFile() {
        Vector vector = HCFileRule.expandFilePaths(this.mPath);
        int n = 5;
        for (int k = 0; k < vector.size() && n != 0; ++k) {
            String string = (String)vector.get(k);
            File file = new File(string);
            boolean bl = file.exists();
            if (!bl) continue;
            n = this.mAge != -1 && this.isFileTooOld(file, string, this.mAge) ? 1 : ((!HCUtil.isEmpty(this.mChecksumsString) || !HCUtil.isEmpty(this.mChecksumsSha256String)) && !this.checkChecksum(file, string) ? 2 : 0);
        }
        return n;
    }

    @Override
    public String evaluate() {
        String string = null;
        int n = this.findFile();
        if (0 == n && this.mFlag || 0 != n && !this.mFlag) {
            return null;
        }
        if (this.mFlag) {
            switch (n) {
                case 5: {
                    HCUtil.logInfo("HCFileRule: required file does not exist");
                    string = "Required file not found";
                    break;
                }
                case 1: {
                    HCUtil.logInfo("HCFileRule: Detected file with " + this.mLastTooOldFileAge + " days old which is older than expected");
                    string = "Detected file with " + this.mLastTooOldFileAge + " days old which is older than expected";
                    break;
                }
                case 2: {
                    string = "checksum does not match";
                    break;
                }
            }
        } else {
            HCUtil.logInfo("HCFileRule: denied file exists");
            string = "Found restricted file";
        }
        return string;
    }

    public static void deleteFile(String string) {
        Vector vector = HCFileRule.expandFilePaths(string);
        for (int k = 0; k < vector.size(); ++k) {
            String string2 = (String)vector.get(k);
            HCUtil.logInfo("HCFileRule: deleting file");
            File file = new File(string2);
            if (file.exists()) {
                boolean bl = false;
                try {
                    bl = file.delete();
                }
                catch (SecurityException securityException) {
                    HCUtil.logError("HCFileRule: security exception trying to delete file: " + securityException.toString());
                }
                if (bl) continue;
                HCUtil.logError("HCFileRule: Failed to delete the file");
                continue;
            }
            HCUtil.logInfo("HCFileRule: Required file does not exist");
        }
        if (vector.size() == 0) {
            HCUtil.logInfo("HCFileRule: no files matching delete path ");
        }
    }
}

