/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.NARPlatform.linux;

import com.neoteris.Logger;
import com.neoteris.Util;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.juniper.tnc.HttpNAR.IProxyAuth;
import net.juniper.tnc.HttpNAR.NARPlatform;
import net.juniper.tnc.HttpNAR.NARUtil;
import net.juniper.tnc.NARPlatform.linux.CommandOutputThread;
import net.juniper.tnc.NARPlatform.linux.ProxyAuth;

public class LinuxNARlatform
extends NARPlatform {
    public static int mLogLevel = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinuxNARlatform() throws Exception {
        Class<LinuxNARlatform> clazz = LinuxNARlatform.class;
        synchronized (LinuxNARlatform.class) {
            if (NARPlatform.thePlatform != null) {
                throw new Exception("Only one TNCCPlatform instance allowed");
            }
            NARPlatform.thePlatform = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public IProxyAuth getProxyAuth() {
        return new ProxyAuth();
    }

    @Override
    public String execCommand(String string) {
        String string2 = null;
        try {
            Process process = Runtime.getRuntime().exec(string);
            CommandOutputThread commandOutputThread = new CommandOutputThread(process.getInputStream());
            CommandOutputThread commandOutputThread2 = new CommandOutputThread(process.getErrorStream());
            commandOutputThread.start();
            commandOutputThread2.start();
            int n = process.waitFor();
            if (n != 0) {
                this.logError("Command " + string + " failed; return = " + n + "; error output = " + commandOutputThread2.getOutput());
            }
            string2 = commandOutputThread.getOutput();
        }
        catch (Exception exception) {
            this.logException(exception);
        }
        return string2;
    }

    @Override
    public boolean isMacOSX() {
        return Util.isMacOSX();
    }

    @Override
    public boolean isSolaris() {
        return Util.isSolaris();
    }

    @Override
    public boolean isLinux() {
        return Util.isLinux();
    }

    @Override
    public String getOSName() {
        return Util.getOSName();
    }

    @Override
    public int startLogging(String string) {
        mLogLevel = NARUtil.getInt(string, "log_level", 0);
        Logger.setConfigurationPath("", "dsHostChecker");
        return Logger.setConfigurationLevel(mLogLevel);
    }

    @Override
    public void stopLogging(int n) {
        Logger.setConfigurationLevel(n);
    }

    @Override
    public void logInfo(String string) {
        if (mLogLevel != 0) {
            Logger.log("HCUtil", 0, 2, string);
        }
    }

    @Override
    public void logError(String string) {
        if (mLogLevel != 0) {
            Logger.log("HCUtil", 0, 4, "*** ERROR *** " + string);
        }
    }

    @Override
    public void logException(Exception exception) {
        if (mLogLevel != 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            Logger.log("HCUtil", 0, 4, "*** EXCEPTION ***\n" + byteArrayOutputStream.toString());
        }
    }
}

