/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.client;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import net.juniper.tnc.client.TNCCUtil;
import net.juniper.tnc.client.TNCClient;
import net.juniper.tnc.interfaces.JuniperTNCC;
import org.trustedcomputinggroup.tnc.TNCException;
import org.trustedcomputinggroup.tnc.ifimc.IMC;

public class IMCModule
implements JuniperTNCC {
    private static final String cls = "IMCModule: ";
    private TNCClient mClient;
    private IMC mImcInterface;
    private String mClassName;
    private String mName;
    private long mStatus;
    private long mVersion;
    private long[] mMessageTypes = new long[0];
    public static final long IMC_STATUS_GOOD = 0L;
    public static final long IMC_STATUS_BAD = 1L;

    public IMCModule(TNCClient tNCClient, String string, String string2, String string3, int n) {
        this.mClient = tNCClient;
        this.mClassName = string3;
        this.mVersion = n;
        this.mName = string;
        try {
            this.instantiateIMC(string2);
        }
        catch (Exception exception) {
            TNCCUtil.logException(exception);
            this.mStatus = 1L;
        }
    }

    @Override
    public synchronized void reportMessageTypes(IMC iMC, long[] lArray) throws TNCException {
        this.mMessageTypes = lArray;
    }

    @Override
    public void requestHandshakeRetry(IMC iMC, long l) throws TNCException {
        this.mClient.requestHandshakeRetry(l);
    }

    public void unload() {
        this.mStatus = 1L;
    }

    public void terminate() throws TNCException {
        this.mImcInterface.terminate();
    }

    @Override
    public void logError(String string) {
        TNCCUtil.logError(string);
    }

    @Override
    public void logWarning(String string) {
        TNCCUtil.logInfo(string);
    }

    @Override
    public void logNormal(String string) {
        TNCCUtil.logInfo(string);
    }

    @Override
    public void logDetail(String string) {
        TNCCUtil.logInfo(string);
    }

    @Override
    public void logDebug(String string) {
        TNCCUtil.logInfo(string);
    }

    public synchronized boolean isRegisteredMessageType(long l) {
        long l2 = this.getMessageVendorID(l);
        long l3 = this.getMessageSubtype(l);
        for (int k = 0; k < this.mMessageTypes.length; ++k) {
            long l4 = this.mMessageTypes[k];
            long l5 = this.getMessageSubtype(l4);
            long l6 = this.getMessageVendorID(l4);
            if (!(l4 == l || -1L == l6 && l5 == l3 || 255L == l5 && l6 == l2) && (255L != l5 || -1L != l6)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.mClassName;
    }

    public long getStatus() {
        return this.mStatus;
    }

    public boolean isGood() {
        return 0L == this.mStatus;
    }

    public long getVersion() {
        return this.mVersion;
    }

    public IMC getInterface() {
        return this.mImcInterface;
    }

    private void instantiateIMC(String string) throws Exception {
        Serializable serializable;
        ClassLoader classLoader = null;
        if (null != string && string.length() > 0) {
            serializable = new URI(string);
            if (!((URI)serializable).isAbsolute()) {
                serializable = new URI("file:///").resolve((URI)serializable);
            }
            URL uRL = ((URI)serializable).toURL();
            TNCCUtil.logInfo("IMCModule: instantinating `" + this.mName + "' @ " + uRL);
            classLoader = new URLClassLoader(new URL[]{uRL});
        } else {
            TNCCUtil.logInfo("IMCModule: loading `" + this.mName + "' from classpath.");
            classLoader = this.getClassloader();
        }
        TNCCUtil.logInfo("IMCModule: loading `" + this.mClassName + "'");
        serializable = classLoader.loadClass(this.mClassName);
        this.mImcInterface = (IMC)((Class)serializable).newInstance();
        this.mImcInterface.initialize(this);
        this.mStatus = 0L;
    }

    private long getMessageVendorID(long l) {
        return l >> 8;
    }

    private long getMessageSubtype(long l) {
        return l & 0xFFL;
    }

    @Override
    public ClassLoader getClassloader() {
        return TNCCUtil.getClassLoader();
    }
}

