/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.hostcheckerimc;

import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import net.juniper.tnc.hostcheckerimc.HCFileRule;
import net.juniper.tnc.hostcheckerimc.HCProcessEnum;
import net.juniper.tnc.hostcheckerimc.HCRule;
import net.juniper.tnc.hostcheckerimc.HCUtil;
import net.juniper.tnc.hostcheckerimc.HostChecker;

public class HCPolicy {
    private final String cls = "HCPolicy: ";
    HostChecker mHostChecker = null;
    String mPolicyID = null;
    Vector mRules = null;
    boolean mIsConditional = false;
    String mExpression = null;
    String[] mPostFixExpression = null;
    String mPostFixExprString = null;
    ProcessToKill[] mProcessesToKill = null;
    String[] mFilesToDelete = null;
    String[] mConditionalPolicies = null;
    boolean mCallRemediate = false;
    boolean mDoCustomInstr = false;
    static final int OPERAND_RULEID = 0;
    static final int OPERAND_RESULT = 1;

    public HCPolicy(HostChecker hostChecker, String string) {
        this.mHostChecker = hostChecker;
        this.mPolicyID = string;
        this.mRules = new Vector();
    }

    public void addRule(HCRule hCRule) {
        this.mRules.add(hCRule);
    }

    public String getPolicyID() {
        return this.mPolicyID;
    }

    public void addPolicyData(Properties properties) {
        if (properties == null) {
            return;
        }
        this.mExpression = properties.getProperty("expressionIDs");
        if (!HCUtil.isEmpty(this.mExpression)) {
            this.convertExpressionToPostFix();
        }
        this.mIsConditional = HCUtil.getBoolInt(properties.getProperty("conditional"), "conditional", false);
        String string = properties.getProperty("remediate");
        if (!HCUtil.isEmpty(string)) {
            this.parseRemediationActions(string);
        }
    }

    public void parseRemediationActions(String string) {
        Properties properties = HCUtil.parseParameters(string, '|');
        String string2 = properties.getProperty("KILL");
        String string3 = properties.getProperty("DELETE");
        String string4 = properties.getProperty("POLICIES");
        String string5 = properties.getProperty("REMEDFUNC");
        String string6 = properties.getProperty("CUSTINSTR");
        if (!HCUtil.isEmpty(string2)) {
            String[] stringArray = this.parseList(string2, "^");
            this.mProcessesToKill = new ProcessToKill[stringArray.length];
            for (int k = 0; k < stringArray.length; ++k) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[k], ",");
                int n = stringTokenizer.countTokens() - 1;
                String string7 = stringTokenizer.nextToken();
                String[] stringArray2 = null;
                if (n > 0) {
                    stringArray2 = new String[n];
                    for (int i2 = 0; i2 < n; ++i2) {
                        stringArray2[i2] = stringTokenizer.nextToken().trim();
                    }
                }
                this.mProcessesToKill[k] = new ProcessToKill(string7, stringArray2);
            }
        }
        if (!HCUtil.isEmpty(string3)) {
            this.mFilesToDelete = this.parseList(string3, "^");
        }
        if (!HCUtil.isEmpty(string4)) {
            if (!this.mIsConditional) {
                this.mConditionalPolicies = this.parseList(string4, "^");
            } else {
                HCUtil.logError("HCPolicy: conditional policy " + this.mPolicyID + " cannot itself have remediate POLICIES; ignored");
            }
        }
        if (!HCUtil.isEmpty(string5) && !string5.trim().equals("0")) {
            HCUtil.logError("HCPolicy: REMEDFUNC=" + string5 + " not supported on this platform");
        }
        if (!HCUtil.isEmpty(string6)) {
            this.mDoCustomInstr = string6.trim().equals("1");
        }
    }

    private String[] parseList(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int k = 0; k < n; ++k) {
            stringArray[k] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    private HCRule getRule(String string) {
        HCRule hCRule = null;
        for (int k = 0; k < this.mRules.size() && hCRule == null; ++k) {
            HCRule hCRule2 = (HCRule)this.mRules.get(k);
            if (!string.equals(hCRule2.getRuleid())) continue;
            hCRule = hCRule2;
        }
        return hCRule;
    }

    private int getStackPriority(String string) {
        int n = 0;
        if (string != null) {
            n = string.equals("#") ? 1 : (string.equalsIgnoreCase("AND") ? 3 : (string.equalsIgnoreCase("OR") ? 3 : (string.equals("(") ? 2 : (string.equals(")") ? 4 : 4))));
        }
        return n;
    }

    private int getInputPriority(String string) {
        int n = 0;
        if (string != null) {
            n = string.equals("#") ? 1 : (string.equalsIgnoreCase("AND") ? 3 : (string.equalsIgnoreCase("OR") ? 3 : (string.equals(")") ? 2 : (string.equals("(") ? 4 : 4))));
        }
        return n;
    }

    private void convertExpressionToPostFix() {
        Serializable serializable;
        Vector<String> vector = new Vector<String>();
        try {
            String string;
            serializable = new Stack<String>();
            ((Stack)serializable).push("#");
            StringTokenizer stringTokenizer = new StringTokenizer(this.mExpression, " ");
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                string = stringTokenizer.nextToken();
                int n2 = this.getInputPriority(string);
                while (n2 <= (n = this.getStackPriority((String)((Stack)serializable).peek()))) {
                    String string2 = (String)((Stack)serializable).pop();
                    if (string2.equals(")") || string2.equals("(") || string2.equals("#")) continue;
                    vector.add(string2);
                }
                ((Stack)serializable).push(string);
            }
            while (!((Stack)serializable).empty()) {
                string = (String)((Stack)serializable).pop();
                if (string.equals(")") || string.equals("(") || string.equals("#")) continue;
                vector.add(string);
            }
        }
        catch (EmptyStackException emptyStackException) {
            HCUtil.logError("HCPolicy: Stack underflow during parsing of expression " + this.mExpression);
        }
        this.mPostFixExpression = new String[vector.size()];
        serializable = new StringBuffer();
        for (int k = 0; k < vector.size(); ++k) {
            this.mPostFixExpression[k] = (String)vector.get(k);
            ((StringBuffer)serializable).append(this.mPostFixExpression[k]).append(" ");
        }
        this.mPostFixExprString = ((StringBuffer)serializable).toString();
        HCUtil.logInfo("HCPolicy: converted expression " + this.mExpression + " into post-fix expression " + this.mPostFixExprString);
    }

    private String evalRule(HCRule hCRule) {
        String string = hCRule.getRuleid() + " " + hCRule.getRulename();
        HCUtil.logInfo("HCPolicy: evaluating rule " + string);
        String string2 = hCRule.evaluate();
        HCUtil.logInfo("HCPolicy: result of rule " + string + ": " + (string2 == null ? "OK" : "NOTOK; error = " + string2));
        return string2;
    }

    private Operand evalOperand(Operand operand) {
        Operand operand2 = null;
        if (operand.mType == 0) {
            String string = operand.mValue;
            HCRule hCRule = null;
            for (int k = 0; k < this.mRules.size(); ++k) {
                HCRule hCRule2 = (HCRule)this.mRules.get(k);
                if (!string.equals(hCRule2.getRuleid())) continue;
                hCRule = hCRule2;
                break;
            }
            if (hCRule != null) {
                operand2 = new Operand(1, this.evalRule(hCRule));
            } else {
                String string2 = "rule id " + string + " not found in policy " + this.mPolicyID;
                HCUtil.logError("HCPolicy: " + string2);
                operand2 = new Operand(1, string2);
            }
        } else {
            operand2 = operand;
        }
        return operand2;
    }

    private String getRulename(String string) {
        HCRule hCRule = null;
        for (int k = 0; k < this.mRules.size(); ++k) {
            HCRule hCRule2 = (HCRule)this.mRules.get(k);
            if (!string.equals(hCRule2.getRuleid())) continue;
            hCRule = hCRule2;
            break;
        }
        return hCRule != null ? hCRule.getRulename() : null;
    }

    public String evaluate() {
        String string;
        block17: {
            string = null;
            if (this.mRules.size() == 0) {
                string = "no rules in policy " + this.mPolicyID + " for " + (HostChecker.gIsMac ? "Mac" : (HostChecker.gIsLinux ? "Linux" : (HostChecker.gIsSunOS ? "Solaris" : "unknown platform")));
                HCUtil.logInfo("HCPolicy: " + string);
            } else if (this.mPostFixExpression != null && this.mPostFixExpression.length == 1) {
                String string2 = this.mPostFixExpression[0];
                if (string2.equalsIgnoreCase("AND") || string2.equalsIgnoreCase("OR")) {
                    string = "rule expression with AND or OR and no rules";
                    HCUtil.logInfo("HCPolicy: " + string);
                } else {
                    string = this.evalOperand((Operand)(HCPolicy)this.new Operand((int)0, (String)string2)).mValue;
                }
            } else if (this.mPostFixExpression != null) {
                HCUtil.logInfo("HCPolicy: evaluating policy " + this.mPolicyID + " expression " + this.mExpression);
                Stack<Operand> stack = new Stack<Operand>();
                try {
                    for (int k = 0; k < this.mPostFixExpression.length; ++k) {
                        String string3 = this.mPostFixExpression[k];
                        if (string3.equalsIgnoreCase("AND") || string3.equalsIgnoreCase("OR")) {
                            Operand operand = (Operand)stack.pop();
                            Operand operand2 = (Operand)stack.pop();
                            Operand operand3 = this.evalOperand(operand2);
                            if (string3.equalsIgnoreCase("AND") && operand3.mValue != null || string3.equalsIgnoreCase("OR") && operand3.mValue == null) {
                                String string4 = operand.mValue;
                                HCUtil.logInfo("HCPolicy: skipping rule " + string4 + " " + this.getRulename(string4));
                                stack.push(operand3);
                                continue;
                            }
                            stack.push(this.evalOperand(operand));
                            continue;
                        }
                        stack.push(new Operand(0, string3));
                    }
                    Operand operand = (Operand)stack.pop();
                    if (!stack.empty()) {
                        string = "evaluation stack not empty at end of evaluation; remaining operands:";
                        while (!stack.empty()) {
                            string = string + ((Operand)stack.pop()).mValue;
                        }
                        HCUtil.logError("HCPolicy: " + string);
                        break block17;
                    }
                    if (operand.mType == 0) {
                        string = "evaluation result an unevaluated rule with id " + operand.mValue;
                        HCUtil.logError("HCPolicy: " + string);
                        break block17;
                    }
                    string = operand.mValue;
                }
                catch (EmptyStackException emptyStackException) {
                    string = "stack underflow during execution of post-fix expression " + this.mPostFixExprString;
                    HCUtil.logError("HCPolicy: " + string);
                }
            } else {
                HCUtil.logInfo("HCPolicy: evaluating policy " + this.mPolicyID + " no expression");
                for (int k = 0; k < this.mRules.size() && string == null; ++k) {
                    HCRule hCRule = (HCRule)this.mRules.get(k);
                    string = this.evalRule(hCRule);
                }
            }
        }
        return string;
    }

    public boolean hasRemediation() {
        return this.mProcessesToKill != null || this.mFilesToDelete != null || this.mCallRemediate || this.mDoCustomInstr;
    }

    public void doRemediation() {
        if (this.mProcessesToKill != null) {
            HCProcessEnum hCProcessEnum = new HCProcessEnum();
            hCProcessEnum.enumerate();
            for (int k = 0; k < this.mProcessesToKill.length; ++k) {
                ProcessToKill processToKill = this.mProcessesToKill[k];
                hCProcessEnum.killProcess(processToKill.getName(), processToKill.getChecksums());
            }
        }
        if (this.mFilesToDelete != null) {
            for (int k = 0; k < this.mFilesToDelete.length; ++k) {
                HCFileRule.deleteFile(this.mFilesToDelete[k]);
            }
        }
        if (this.mCallRemediate) {
            HCUtil.logError("HCPolicy: remediate() call not supported on this platform");
        }
        if (this.mDoCustomInstr) {
            this.mHostChecker.addFailedPolicyToRemediate(this.mPolicyID);
        }
    }

    public boolean isConditional() {
        return this.mIsConditional;
    }

    public String[] getConditionalPolicies() {
        return this.mConditionalPolicies;
    }

    private class Operand {
        public int mType;
        public String mValue;

        public Operand(int n, String string) {
            this.mType = n;
            this.mValue = string;
        }
    }

    private class ProcessToKill {
        String mName;
        String[] mChecksums;

        public ProcessToKill(String string, String[] stringArray) {
            this.mName = string;
            this.mChecksums = stringArray;
        }

        String getName() {
            return this.mName;
        }

        String[] getChecksums() {
            return this.mChecksums;
        }
    }
}

