/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.hostcheckerimc;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import net.juniper.tnc.hostcheckerimc.HCUtil;
import net.juniper.tnc.hostcheckerimc.HostChecker;

public class HCProcessEnum {
    static final String cls = "HCProcessEnum: ";
    public Hashtable mPath2Pid = new Hashtable();
    public Hashtable mProcessNames = new Hashtable();
    private String mPsPathCommand = "";
    private String mPsNameCommand = "";

    public HCProcessEnum() {
        if (HostChecker.gIsMac) {
            this.mPsPathCommand = "ps -Awwo pid,command";
            this.mPsNameCommand = "ps -Awwco pid,command";
        } else if (HostChecker.gIsSunOS) {
            this.mPsPathCommand = "ps -eo pid,comm";
            this.mPsNameCommand = "ps -eo pid,comm";
        } else {
            this.mPsPathCommand = "ps -Awwo pid,command";
            this.mPsNameCommand = "ps -Awwo pid,comm";
        }
    }

    public boolean enumerate() {
        this.mPath2Pid.clear();
        this.mProcessNames.clear();
        Hashtable hashtable = this.enumerateNames();
        if (hashtable.size() == 0) {
            return false;
        }
        HCUtil.logInfo("HCProcessEnum: executing command " + this.mPsPathCommand);
        String string = HCUtil.execCommand(this.mPsPathCommand);
        if (string == null) {
            HCUtil.logError("HCProcessEnum: cannot get current processes.");
            return false;
        }
        int n = string.indexOf(10);
        int n2 = 0;
        while ((n = string.indexOf(10, n2 = n + 1)) != -1) {
            StringBuffer stringBuffer;
            String string2 = string.substring(n2, n).trim();
            long l = this.parsePidAndName(string2, stringBuffer = new StringBuffer(), false);
            if (l == 0L) continue;
            String string3 = stringBuffer.toString();
            String string4 = (String)hashtable.get(new Long(l));
            if (null == string4) continue;
            string3 = this.splitPath(string3, string4);
            this.addPathname2Pid(string3 + string4, l);
            this.addName2Path(string4, string3 + string4);
            this.addName2Path(string3 + string4, string3 + string4);
        }
        return true;
    }

    public void killProcess(String string, String[] stringArray) {
        Vector vector = this.expandProcessNames(string);
        for (int k = 0; k < vector.size(); ++k) {
            String string2 = (String)vector.get(k);
            Vector vector2 = (Vector)this.mProcessNames.get(string2);
            if (vector2 != null) {
                for (int i2 = 0; i2 < vector2.size(); ++i2) {
                    int n;
                    Object object;
                    String string3 = (String)vector2.get(i2);
                    boolean bl = false;
                    if (stringArray != null) {
                        object = HCProcessEnum.computeChecksum(string3);
                        if (object != null) {
                            for (n = 0; n < stringArray.length && !bl; ++n) {
                                bl = ((String)object).equalsIgnoreCase(stringArray[n]);
                            }
                        }
                        HCUtil.logInfo("HCProcessEnum: process to kill " + string2 + "; " + (bl ? " " : "no ") + "match on checksum = " + (String)object);
                    } else {
                        bl = true;
                    }
                    object = (Vector)this.mPath2Pid.get(string3);
                    if (!bl) continue;
                    for (n = 0; n < ((Vector)object).size(); ++n) {
                        HCUtil.logInfo("HCProcessEnum: killing process " + string2 + "; pid = " + ((Vector)object).get(n));
                        String string4 = HCUtil.execCommand("kill -9 " + ((Vector)object).get(n));
                        if (HCUtil.isEmpty(string4)) continue;
                        HCUtil.logError("HCProcessEnum: kill process " + string2 + "; path = " + string3 + "; pid = " + ((Vector)object).get(n) + " failed: " + string4);
                    }
                }
                continue;
            }
            HCUtil.logInfo("HCProcessEnum: process to kill " + string2 + " does not exist");
        }
        if (vector.size() == 0) {
            HCUtil.logInfo("HCProcessEnum: no processes to kill matching pattern " + string);
        }
    }

    public Vector expandProcessNames(String string) {
        Vector<String> vector = new Vector<String>();
        if ((string = HCUtil.substituteEnvVars(string)) == null) {
            return vector;
        }
        if (HCUtil.containsWildcards(string)) {
            String string2 = HCUtil.convertWildcardsToRegex(string);
            HCUtil.logInfo("HCProcessEnum: process name " + string + " converted to regex " + string2);
            try {
                Pattern pattern = Pattern.compile(string2);
                Enumeration enumeration = this.mProcessNames.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    if (!pattern.matcher(string3).matches()) continue;
                    vector.add(string3);
                }
            }
            catch (Exception exception) {
                HCUtil.logException(exception);
            }
        } else {
            vector.add(string);
        }
        return vector;
    }

    public static String computeChecksum(String string) {
        String string2 = null;
        File file = new File(string);
        if (file.canRead()) {
            string2 = HCUtil.computeFileMD5(file);
        } else {
            HCUtil.logError("HCProcessEnum: cannot read process `" + string + "' binary to compute checksum");
        }
        return string2;
    }

    public static String computeSha256Checksum(String string) {
        String string2 = null;
        File file = new File(string);
        if (file.canRead()) {
            string2 = HCUtil.computeFileSHA256(file);
        } else {
            HCUtil.logError("HCProcessEnum: cannot read process `" + string + "' binary to compute checksum");
        }
        return string2;
    }

    private Hashtable enumerateNames() {
        Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
        HCUtil.logInfo("HCProcessEnum: executing command " + this.mPsNameCommand);
        String string = HCUtil.execCommand(this.mPsNameCommand);
        if (string == null) {
            HCUtil.logError("HCProcessEnum: cannot get current process names.");
            return hashtable;
        }
        int n = string.indexOf(10);
        int n2 = 0;
        while ((n = string.indexOf(10, n2 = n + 1)) != -1) {
            StringBuffer stringBuffer;
            String string2 = string.substring(n2, n).trim();
            long l = this.parsePidAndName(string2, stringBuffer = new StringBuffer(), true);
            if (l == 0L) continue;
            hashtable.put(new Long(l), stringBuffer.toString());
        }
        return hashtable;
    }

    private long parsePidAndName(String string, StringBuffer stringBuffer, boolean bl) {
        int n;
        String[] stringArray = string.split("\\s+", 2);
        if (stringArray.length < 2) {
            return 0L;
        }
        long l = 0L;
        try {
            l = Long.parseLong(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            HCUtil.logError("HCProcessEnum: bad pid in ps command line " + string);
        }
        String string2 = stringArray[1];
        if (bl && -1 != (n = string2.lastIndexOf(File.separator))) {
            string2 = string2.substring(n + 1);
        }
        stringBuffer.append(string2);
        return l;
    }

    private String splitPath(String string, String string2) {
        int n = string.indexOf(File.separator + string2 + " ");
        if (-1 == n) {
            n = string.lastIndexOf(File.separator + string2);
        }
        String string3 = -1 == n ? "" : string.substring(0, n + 1);
        return string3;
    }

    private void addPathname2Pid(String string, long l) {
        Vector<Long> vector = (Vector<Long>)this.mPath2Pid.get(string);
        if (null == vector) {
            vector = new Vector<Long>();
            this.mPath2Pid.put(string, vector);
        }
        vector.add(new Long(l));
    }

    private void addName2Path(String string, String string2) {
        Vector<String> vector = (Vector<String>)this.mProcessNames.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.mProcessNames.put(string, vector);
        }
        vector.add(string2);
    }
}

