/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.hostcheckerimc;

import java.util.zip.Inflater;
import net.juniper.tnc.hostcheckerimc.HCPolicy;
import net.juniper.tnc.hostcheckerimc.HCUtil;
import net.juniper.tnc.hostcheckerimc.HostChecker;
import net.juniper.tnc.interfaces.JuniperTNCC;
import org.trustedcomputinggroup.tnc.TNCException;
import org.trustedcomputinggroup.tnc.ifimc.IMC;
import org.trustedcomputinggroup.tnc.ifimc.IMCConnection;
import org.trustedcomputinggroup.tnc.ifimc.TNCC;

public class HostCheckerIMC
implements IMC {
    private static final String cls = "HostCheckerIMC: ";
    private static final String zipPrefix = "COMPRESSED:";
    private static final String remedPrefix = "REMEDIATE:";
    public static final long FUNK_MESSAGE_TYPE_0 = 361238L;

    @Override
    public void batchEnding(IMCConnection iMCConnection) throws TNCException {
    }

    @Override
    public void beginHandshake(IMCConnection iMCConnection) throws TNCException {
        HCUtil.logInfo("HostCheckerIMC: new handshake");
        iMCConnection.sendMessage(361238L, "policy request\u0000".getBytes());
    }

    @Override
    public void initialize(TNCC tNCC) throws TNCException {
        JuniperTNCC juniperTNCC = null;
        try {
            juniperTNCC = (JuniperTNCC)tNCC;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        HCUtil.startLogging(juniperTNCC);
        tNCC.reportMessageTypes(this, new long[]{361238L});
        HCUtil.logInfo("HostCheckerIMC: initialized");
    }

    @Override
    public void notifyConnectionChange(IMCConnection iMCConnection, long l) throws TNCException {
        HCUtil.logInfo("HostCheckerIMC: connection state changed to " + l);
    }

    @Override
    public void receiveMessage(IMCConnection iMCConnection, long l, byte[] byArray) throws TNCException {
        HCUtil.logInfo("HostCheckerIMC: receive message type " + l);
        try {
            String string = new String(byArray);
            string = string.startsWith(zipPrefix) ? this.uncompressMessage(byArray) : HCUtil.byteArrayToString(byArray);
            HCUtil.logInfo(string);
            HostChecker hostChecker = new HostChecker();
            if (string.startsWith(remedPrefix)) {
                HCUtil.logInfo("HostCheckerIMC: performing remediation.");
                HCPolicy hCPolicy = new HCPolicy(hostChecker, "Policy ID");
                hCPolicy.parseRemediationActions(string.substring(remedPrefix.length()));
                if (hCPolicy.hasRemediation()) {
                    hCPolicy.doRemediation();
                }
            } else {
                hostChecker.run(string);
                iMCConnection.sendMessage(361238L, hostChecker.getReport());
                HCUtil.logInfo("HostCheckerIMC: sending response:");
                HCUtil.logInfo(HCUtil.byteArrayToString(hostChecker.getReport()));
            }
        }
        catch (Exception exception) {
            HCUtil.logException(exception);
            HCUtil.logInfo("HostCheckerIMC: caught exception; Report will not be sent.");
            throw new TNCException(exception.getMessage(), 9L);
        }
    }

    @Override
    public void terminate() throws TNCException {
        HCUtil.logInfo("HostCheckerIMC: terminated.");
        HCUtil.stopLogging();
    }

    String uncompressMessage(byte[] byArray) throws Exception {
        String string = new String(byArray);
        int n = string.indexOf(58, zipPrefix.length());
        if (n < 0) {
            HCUtil.logError("HostCheckerIMC: Invalid message format, missing `:' after original length.");
            return "";
        }
        int n2 = Integer.parseInt(string.substring(zipPrefix.length(), n));
        if (0 >= n2) {
            HCUtil.logError("HostCheckerIMC: Invalid message format, bogus original length: " + n2);
            return "";
        }
        if (byArray.length <= n + 1) {
            HCUtil.logError("HostCheckerIMC: Invalid message format, missing compressed data");
            return "";
        }
        byte[] byArray2 = new byte[n2];
        Inflater inflater = new Inflater();
        inflater.setInput(byArray, 1 + n, byArray.length - n - 1);
        int n3 = inflater.inflate(byArray2);
        if (n3 != n2) {
            HCUtil.logError("HostCheckerIMC: Invalid message format, original length does not match uncompressed length.");
            return "";
        }
        return HCUtil.byteArrayToString(byArray2);
    }
}

