/*
 * Decompiled with CFR 0.152.
 */
import com.neoteris.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FileUtil {
    public static void Unzip(File file, File file2) throws FileNotFoundException, ZipException, IOException {
        Logger.log("../../common/FileUtil.java", 43, 2, "Unzip file [" + file.toString() + "] to directory [" + file2.toString() + "] starting.");
        ZipFile zipFile = new ZipFile(file);
        File file3 = null;
        File file4 = null;
        File file5 = file2;
        if (!file5.exists()) {
            file5.mkdirs();
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            file4 = new File(zipEntry.getName());
            file3 = new File(file5, file4.getPath());
            file3.deleteOnExit();
            if (zipEntry.isDirectory()) {
                if (file3.exists()) continue;
                file3.mkdirs();
                continue;
            }
            if (!file3.getParentFile().exists()) {
                file3.getParentFile().mkdirs();
                file3.getParentFile().deleteOnExit();
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            FileUtil.copyFile(bufferedInputStream, file3);
            bufferedInputStream.close();
        }
        zipFile.close();
        Logger.log("../../common/FileUtil.java", 97, 2, "Unzip done!");
    }

    public static void DeleteObject(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                Logger.log("../../common/FileUtil.java", 119, 2, "DeleteObject (recursive directory) [" + file.toString() + "]");
                FileUtil.deleteDirectory(file, file.getPath().length());
            } else {
                Logger.log("../../common/FileUtil.java", 125, 2, "DeleteObject (single file) [" + file.toString() + "]");
                file.delete();
            }
        } else {
            Logger.log("../../common/FileUtil.java", 132, 2, "DeleteObject [" + file.toString() + "] has nothing to delete.");
        }
    }

    private static void deleteDirectory(File file, int n) {
        if (file != null && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int k = 0; k < fileArray.length; ++k) {
                File file2 = fileArray[k];
                if (file2.getPath().length() <= n) continue;
                if (file2.isDirectory()) {
                    FileUtil.deleteDirectory(file2, file2.getPath().length());
                    continue;
                }
                Logger.log("../../common/FileUtil.java", 167, 2, "deleteDirectory (single file) [" + file2.toString() + "]");
                file2.delete();
            }
            Logger.log("../../common/FileUtil.java", 172, 2, "deleteDirectory (empty directory) [" + file.toString() + "]");
            file.delete();
        }
    }

    public static long copyFile(URL uRL, File file) throws IOException {
        long l = 0L;
        InputStream inputStream = uRL.openStream();
        l = FileUtil.copyFile(inputStream, file);
        inputStream.close();
        return l;
    }

    public static long copyFile(InputStream inputStream, File file) throws IOException {
        return FileUtil.copyFile(inputStream, file, -1);
    }

    public static long copyFile(InputStream inputStream, File file, int n) throws IOException {
        return FileUtil.copyFile(inputStream, file, n, null);
    }

    public static long copyFile(InputStream inputStream, File file, int n, ChangeListener changeListener) throws IOException {
        Logger.log("../../common/FileUtil.java", 211, 2, "copy stream to new file [" + file.toString() + "]");
        byte[] byArray = new byte[4096];
        int n2 = 0;
        long l = 0L;
        if (n == 0) {
            return 0L;
        }
        file.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        while ((n2 = inputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n2);
            l += (long)n2;
            if (changeListener != null) {
                Integer n3 = new Integer(n2);
                changeListener.stateChanged(new ChangeEvent(n3));
            }
            if (n <= -1 || l < (long)n) continue;
        }
        fileOutputStream.close();
        return l;
    }
}

