/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.HttpNAR;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import net.juniper.tnc.HttpNAR.NARUtil;
import org.trustedcomputinggroup.tnc.TNCException;
import org.trustedcomputinggroup.tnc.ifimc.IMCConnection;

public class HandshakeRetryRequestor
extends Thread {
    private Collection mRequests = Collections.synchronizedCollection(new Vector());
    private boolean mTerminate = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NARUtil.logInfo("HandshakeRetryRequestor is started");
        try {
            block10: while (true) {
                Object object;
                Object object2 = this;
                synchronized (object2) {
                    this.wait(10000L);
                    if (this.mTerminate) {
                        break;
                    }
                }
                object2 = new Date();
                Vector<HandshakeRequest> vector = new Vector<HandshakeRequest>();
                Collection collection = this.mRequests;
                synchronized (collection) {
                    object = this.mRequests.iterator();
                    while (object.hasNext()) {
                        HandshakeRequest handshakeRequest = (HandshakeRequest)object.next();
                        if (handshakeRequest.mTimestamp.compareTo((Date)object2) > 0) continue;
                        vector.add(handshakeRequest);
                        object.remove();
                    }
                }
                int n = 0;
                while (true) {
                    if (n >= vector.size()) continue block10;
                    object = (HandshakeRequest)vector.elementAt(n);
                    try {
                        ((HandshakeRequest)object).mConnection.requestHandshakeRetry(((HandshakeRequest)object).mRequestReason);
                    }
                    catch (TNCException tNCException) {
                        NARUtil.logException(tNCException);
                    }
                    ++n;
                }
                break;
            }
        }
        catch (Exception exception) {
            NARUtil.logException(exception);
        }
        NARUtil.logInfo("HandshakeRetryRequestor is terminated");
    }

    public void requestHandshakeRetry(long l, IMCConnection iMCConnection, long l2) {
        this.mRequests.add(new HandshakeRequest(l, iMCConnection, l2));
        NARUtil.logInfo("HandshakeRetryRequestor new request will execute at " + new Date(l).toString());
    }

    public synchronized void terminate() {
        this.mTerminate = true;
        this.notify();
    }

    private class HandshakeRequest {
        long mRequestReason;
        IMCConnection mConnection;
        Date mTimestamp;

        HandshakeRequest(long l, IMCConnection iMCConnection, long l2) {
            this.mRequestReason = l2;
            this.mConnection = iMCConnection;
            this.mTimestamp = new Date(l);
        }
    }
}

