/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.HttpNAR;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import net.juniper.tnc.HttpNAR.Base64;
import net.juniper.tnc.HttpNAR.NARUtil;

public class HttpConnection {
    private static final String cls = "TNCoHTTP: ";
    private String mIveHost = null;
    private String mPreauthCookie = null;
    private String mSignIn = null;
    private String mPreauthOpts = null;
    private String mUserAgent;
    private int mConnId = 0;
    private long mCheckInterval = 0L;
    private boolean mLastSessionStatus = false;
    int mNextFileIndex = 2;

    public HttpConnection(String string, String string2, String string3, String string4) {
        this.mIveHost = string;
        this.mPreauthCookie = string2;
        this.mUserAgent = string3;
        this.mSignIn = string4;
    }

    public String getCookie() {
        return this.mPreauthCookie;
    }

    public boolean isHandshakeInProgress() {
        return 0 != this.mConnId;
    }

    public boolean getLastSessionStatus() {
        return this.mLastSessionStatus;
    }

    public long getCheckInterval() {
        return this.mCheckInterval;
    }

    public int sendUpdate(byte[] byArray, ByteArrayOutputStream byteArrayOutputStream, boolean bl) throws Exception {
        NARUtil.logInfo("TNCoHTTP: sending update = ");
        NARUtil.logData(byArray);
        String string = Base64.byteArrayToBase64(byArray);
        String string2 = "https://" + this.mIveHost + "/dana-na/hc/tnchcupdate.cgi";
        NARUtil.logInfo("TNCoHTTP: opening connection to " + string2);
        URL uRL = new URL(string2);
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setRequestProperty("Cookie", "DSPREAUTH=" + this.mPreauthCookie + ";DSSIGNIN=" + this.mSignIn);
        if (this.mUserAgent.length() > 0) {
            httpsURLConnection.setRequestProperty("User-Agent", this.mUserAgent);
        }
        NARUtil.setConnectTimeout(httpsURLConnection, 2000);
        httpsURLConnection.connect();
        OutputStream outputStream = httpsURLConnection.getOutputStream();
        PrintWriter printWriter = new PrintWriter(outputStream);
        NARUtil.logInfo("TNCoHTTP: sending update...");
        printWriter.print("connId=");
        printWriter.print(this.mConnId);
        printWriter.print(";");
        printWriter.print("msg=");
        printWriter.print(string);
        printWriter.print(";");
        if (bl) {
            printWriter.print("firsttime=1;");
        }
        printWriter.close();
        String string3 = null;
        int n = 1;
        while ((string3 = httpsURLConnection.getHeaderFieldKey(n)) != null) {
            String string4 = httpsURLConnection.getHeaderField(n);
            if (string3.equalsIgnoreCase("Set-Cookie") && string4.startsWith("DSPREAUTH=")) {
                int n2 = string4.indexOf(59);
                this.mPreauthCookie = string4.substring(10, n2);
                this.mPreauthOpts = string4.substring(n2);
                NARUtil.logInfo("TNCoHTTP: received response DSPREAUTH = " + this.mPreauthCookie + this.mPreauthOpts);
            }
            ++n;
        }
        n = httpsURLConnection.getResponseCode();
        NARUtil.logInfo("TNCoHTTP: received response code = " + n);
        if (n == 200) {
            this.parseHttpResponse(new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream())), byteArrayOutputStream);
        }
        return n;
    }

    private void parseHttpResponse(BufferedReader bufferedReader, ByteArrayOutputStream byteArrayOutputStream) throws Exception {
        String string = bufferedReader.readLine();
        string = bufferedReader.readLine();
        if (string.startsWith("connId=")) {
            int n = Integer.parseInt(string.substring(7));
            if (0 == this.mConnId || 0 == n || n == this.mConnId) {
                this.mConnId = n;
                string = bufferedReader.readLine();
                if (string.startsWith("msg=")) {
                    String string2 = "";
                    string = string.substring(4);
                    while (bufferedReader.ready() && string.length() > 0) {
                        string2 = string2 + string;
                        string = bufferedReader.readLine();
                    }
                    if (string2.length() > 0) {
                        byteArrayOutputStream.write(Base64.base64ToByteArray(string2));
                        NARUtil.logData(byteArrayOutputStream.toByteArray());
                    }
                    if ((string = bufferedReader.readLine()) != null && string.startsWith("interval=")) {
                        this.mCheckInterval = Long.parseLong(string.substring(9));
                        NARUtil.logInfo("TNCoHTTP: periodic check interval " + this.mCheckInterval + " min.");
                    }
                    if ((string = bufferedReader.readLine()) != null && string.startsWith("SESSION=")) {
                        this.mLastSessionStatus = string.substring(8).equals("OK");
                        NARUtil.logInfo("TNCoHTTP: last session status `" + string.substring(8) + "'");
                    }
                    return;
                }
            }
        }
        NARUtil.logInfo("TNCoHTTP: invalid response from tnchcupdate.cgi: " + string);
        throw new Exception("Invalid response from TNCS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readNextFileData() {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        try {
            String string = "/homes/yavlasov/eac" + this.mNextFileIndex;
            File file = new File(string);
            if (file.exists()) {
                byArray = new byte[(int)file.length()];
                fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
                ++this.mNextFileIndex;
            } else {
                System.out.println("Could not find file");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                    fileInputStream = null;
                }
                catch (IOException iOException) {
                    fileInputStream = null;
                }
            }
        }
        if (null != byArray) {
            NARUtil.logInfo("TNCoHTTP: received response = ");
            NARUtil.logData(byArray);
        }
        return null == byArray ? new byte[]{} : byArray;
    }
}

