/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.HttpNAR;

import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import net.juniper.tnc.HttpNAR.NARUtil;
import net.juniper.tnc.HttpNAR.TncHandshake;

public class LoginTimeoutThread
extends Thread {
    public static final String cls = "LoginTimeoutThread: ";
    private TncHandshake mHandshake = null;
    private long mLoginTimeout = 0L;
    public boolean mRunning = false;

    LoginTimeoutThread(TncHandshake tncHandshake, long l) {
        this.mHandshake = tncHandshake;
        this.mLoginTimeout = l;
    }

    public long getLoginTimeout() {
        return this.mLoginTimeout;
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    @Override
    public void run() {
        NARUtil.logInfo("LoginTimeoutThread: sleeping for " + this.mLoginTimeout + " minute(s)");
        this.mRunning = true;
        try {
            Thread.sleep(this.mLoginTimeout * 60L * 1000L);
            if (!this.mHandshake.isLoggedIn()) {
                NARUtil.logInfo("LoginTimeoutThread: login timeout expired; check IVE for a user session");
                String string = "https://" + this.mHandshake.getIcURL() + "/dana-na/hc/hcupdate.cgi?query=checkusersession";
                NARUtil.logInfo("LoginTimeoutThread: opening connection to " + string);
                URL uRL = new URL(string);
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
                httpsURLConnection.setRequestProperty("Cookie", "DSPREAUTH=" + this.mHandshake.getCookie());
                httpsURLConnection.connect();
                int n = httpsURLConnection.getResponseCode();
                if (n == 200) {
                    NARUtil.logInfo("LoginTimeoutThread: response from IVE = 200: user has logged in");
                    this.mHandshake.setLoggedIn(true);
                } else {
                    NARUtil.logInfo("LoginTimeoutThread: response from IVE = " + n + "; user has not logged in; stopping Host Checker");
                    this.mHandshake.stop();
                }
            } else {
                NARUtil.logInfo("LoginTimeoutThread: login timeout expired; SESSION:OK previously returned by hcupdate.cgi");
            }
        }
        catch (InterruptedException interruptedException) {
            NARUtil.logInfo("LoginTimeoutThread: interrupted");
        }
        catch (Exception exception) {
            NARUtil.logException(exception);
        }
        this.mRunning = false;
    }
}

