/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.tnc.hostcheckerimc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import net.juniper.tnc.hostcheckerimc.HCFileRule;
import net.juniper.tnc.hostcheckerimc.HCPolicy;
import net.juniper.tnc.hostcheckerimc.HCPortRule;
import net.juniper.tnc.hostcheckerimc.HCProcessRule;
import net.juniper.tnc.hostcheckerimc.HCUtil;

public class HostChecker {
    private static final String cls = "HostChecker: ";
    public static boolean gIsMac = false;
    public static boolean gIsLinux = false;
    public static boolean gIsSunOS = false;
    private String mIveHost = null;
    private String mPreauthID = null;
    private String mLocale = null;
    private Random mRandGen = null;
    private Vector mPolicyIDs = null;
    private Hashtable mPolicies = null;
    private Vector mFailedPolicies = null;
    private HashSet mFilesToDelete = null;
    private int mInterval = 0;
    private int mLoginTimeout = 0;
    private StringBuffer mReport;
    static final int UNKNOWN = 0;
    static final int FILE_RULE = 1;
    static final int PROCESS_RULE = 2;
    static final int PORT_RULE = 3;
    static final int POLICYDATA = 4;

    public int getInterval() {
        return this.mInterval;
    }

    public byte[] getReport() {
        return this.mReport.toString().getBytes();
    }

    private Vector getPolicyParameters(String string) {
        Vector<Properties> vector = new Vector<Properties>();
        int[] nArray = new int[]{60, -3, -3, 61, 34, -3, 61, 34, 62};
        String[] stringArray = new String[]{"param", "name", "value"};
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                String[] stringArray2 = new String[]{null, null};
                StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string2));
                int n2 = 0;
                int n3 = 0;
                for (n = 0; n < nArray.length && nArray[n] == streamTokenizer.nextToken() && (-3 != streamTokenizer.ttype || 0 == streamTokenizer.sval.compareToIgnoreCase(stringArray[n2++])); ++n) {
                    if (34 != streamTokenizer.ttype) continue;
                    stringArray2[n3++] = streamTokenizer.sval;
                }
                if (n == nArray.length) {
                    if (stringArray2[0] == null || stringArray2[1] == null) continue;
                    HCUtil.logInfo("HostChecker: read from pipe " + stringArray2[0] + " = " + stringArray2[1]);
                    Properties properties = HCUtil.parseParameters(stringArray2[1], ';');
                    properties.setProperty("parameter", stringArray2[0]);
                    vector.add(properties);
                    continue;
                }
                HCUtil.logError("HostChecker: invalid input string " + string2);
            }
        }
        catch (IOException iOException) {
            HCUtil.logException(iOException);
        }
        return vector;
    }

    private void setupHCPolicies(Vector vector) {
        this.mPolicyIDs = new Vector();
        this.mPolicies = new Hashtable();
        for (int k = 0; k < vector.size(); ++k) {
            int n;
            int n2;
            Properties properties = (Properties)vector.get(k);
            String string = properties.getProperty("policy");
            if (HCUtil.isEmpty(string)) {
                HCUtil.logError("HostChecker: no policy in parameter" + (k + 1));
                continue;
            }
            HCPolicy hCPolicy = (HCPolicy)this.mPolicies.get(string);
            if (hCPolicy == null) {
                hCPolicy = new HCPolicy(this, string);
                this.mPolicyIDs.add(string);
                this.mPolicies.put(string, hCPolicy);
            }
            if ((n2 = HCUtil.getInt(properties.getProperty("object_number"), "object_number", -1)) == -1) {
                HCUtil.logError("HostChecker: missing or invalid object_number in parameter" + (k + 1));
                continue;
            }
            String string2 = properties.getProperty("provider");
            if (HCUtil.isEmpty(string2)) {
                HCUtil.logError("HostChecker: no provider in parameter" + (k + 1));
                continue;
            }
            int n3 = string2.equalsIgnoreCase("file") ? 1 : (string2.equalsIgnoreCase("process") ? 2 : (string2.equalsIgnoreCase("port") ? 3 : (n = string2.equalsIgnoreCase("policydata") ? 4 : 0)));
            if (n == 0) {
                HCUtil.logError("HostChecker: unsupported provider " + string2 + " in parameter" + (k + 1));
                continue;
            }
            block7: for (int i2 = 1; i2 <= n2; ++i2) {
                switch (n) {
                    case 1: {
                        hCPolicy.addRule(new HCFileRule(properties, i2));
                        continue block7;
                    }
                    case 2: {
                        hCPolicy.addRule(new HCProcessRule(properties, i2));
                        continue block7;
                    }
                    case 3: {
                        hCPolicy.addRule(new HCPortRule(properties, i2));
                        continue block7;
                    }
                    case 4: {
                        hCPolicy.addPolicyData(properties);
                    }
                }
            }
        }
    }

    public HCPolicy getPolicy(String string) {
        return (HCPolicy)this.mPolicies.get(string);
    }

    private boolean evaluatePolicy(HCPolicy hCPolicy, StringBuffer stringBuffer) {
        boolean bl = false;
        String string = hCPolicy.getPolicyID();
        String string2 = hCPolicy.evaluate();
        if (string2 != null && hCPolicy.hasRemediation()) {
            hCPolicy.doRemediation();
            string2 = hCPolicy.evaluate();
        }
        stringBuffer.append("\npolicy:").append(string);
        if (string2 == null) {
            stringBuffer.append("\nstatus:OK\n");
            HCUtil.logInfo("HostChecker: policy " + string + ": OK");
            bl = true;
        } else {
            stringBuffer.append("\nstatus:NOTOK\nerror:").append(string2).append("\n");
            HCUtil.logInfo("HostChecker: policy " + string + ": NOTOK; error = " + string2);
            bl = false;
        }
        return bl;
    }

    public void addFailedPolicyToRemediate(String string) {
        this.mFailedPolicies.add(string);
    }

    public void evaluatePoliciesAndSendUpdate() throws Exception {
        HCUtil.logInfo("-----------------------------------------------------");
        HCUtil.logInfo("HostChecker: evaluating HC policies");
        this.mFailedPolicies = new Vector();
        this.mReport = new StringBuffer();
        for (int k = 0; k < this.mPolicyIDs.size(); ++k) {
            String[] stringArray;
            boolean bl;
            String string = (String)this.mPolicyIDs.get(k);
            HCPolicy hCPolicy = (HCPolicy)this.mPolicies.get(string);
            if (hCPolicy.isConditional() || (bl = this.evaluatePolicy(hCPolicy, this.mReport)) || (stringArray = hCPolicy.getConditionalPolicies()) == null) continue;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                HCPolicy hCPolicy2 = (HCPolicy)this.mPolicies.get(string2);
                if (hCPolicy2 != null) {
                    this.evaluatePolicy(hCPolicy2, this.mReport);
                    continue;
                }
                HCUtil.logError("HostChecker: conditional policy " + string2 + " for policy " + string + " does not exist; ignored");
            }
        }
    }

    public void run(String string) throws Exception {
        this.mRandGen = new Random(System.currentTimeMillis());
        Vector vector = this.getPolicyParameters(string);
        Properties properties = (Properties)vector.get(0);
        String string2 = properties.getProperty("parameter");
        this.mInterval = HCUtil.getInt(properties.getProperty("interval"), "interval", 60);
        this.mLoginTimeout = HCUtil.getInt(properties.getProperty("process_timeout"), "process_timeout", 0);
        String string3 = properties.getProperty("failurl");
        String string4 = properties.getProperty("hashkey");
        this.mPreauthID = properties.getProperty("id");
        this.mIveHost = properties.getProperty("ivehost");
        this.mLocale = properties.getProperty("locale");
        String string5 = properties.getProperty("user_agent");
        String string6 = properties.getProperty("log_level");
        HCUtil.logInfo("=====================================================");
        HCUtil.logInfo("HostChecker: starting");
        HCUtil.logInfo("HostChecker: ivehost     = " + this.mIveHost);
        HCUtil.logInfo("HostChecker: locale      = " + this.mLocale);
        HCUtil.logInfo("HostChecker: user_agent  = " + string5);
        HCUtil.logInfo("HostChecker: log_level   = " + string6);
        HCUtil.logInfo("HostChecker: Parameter0  = " + string2);
        String string7 = System.getProperty("os.name");
        if (string7 != null) {
            gIsMac = string7.equalsIgnoreCase("MAC OS X");
            gIsLinux = string7.equalsIgnoreCase("Linux");
            gIsSunOS = string7.equalsIgnoreCase("SunOS");
        }
        HCUtil.logInfo("HostChecker: running on " + string7);
        if (!(gIsMac || gIsLinux || gIsSunOS)) {
            HCUtil.logError("HostChecker: unsupported operating system " + string7 + "; stopping...");
            return;
        }
        this.mFilesToDelete = new HashSet();
        this.setupHCPolicies(vector);
        this.evaluatePoliciesAndSendUpdate();
        for (String string8 : this.mFilesToDelete) {
            HCUtil.logInfo("HostChecker: deleting " + string8);
            File file = new File(string8);
            if (!file.exists()) continue;
            file.delete();
        }
        HCUtil.logInfo("HostChecker: stopped");
    }
}

